C      *****************************************************************
C      * Subroutine InParam                                            *
C      * This routine is called when YASE is not being called from     *
C      * TREGRO.  It reads in the tree data that otherwise would be    *
C      * passed from TREGRO.                                           *
C      *                                                               *
C      * Variables:                                                    *
C      * BlkDens   -Output- A vector, of size NLayers, of the bulk     *
C      *                    density of the soil for each layer.  Input *
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Units are g/cm**3.       *
C      *                    (Common block VModel, file VModel.f)       *
C      * CatchArea -Output- A vector, of size NLayers, of the catchment*
C      *                    area for each layer.  Input from TREGRO, or*
C      *                    read into the model by the routine InParam.*
C      *                    Units are m**2.                            *
C      *                    (Common block VModel, file VModel.f)       *
C      * ElapT     -Output- The elapsed time since the last call, i.e.,*
C      *                    the model timestep.  (This is model time,  *
C      *                    not real time.)  Input from TREGRO, or read*
C      *                    into the model by the routine InParam.     *
C      *                    Units are s.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * Frstim    -Output- A flag that is a 1 the first time the soil *
C      *                    model is called and is a 0 otherwise.      *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VModel, file VModel.f)       *
C      * FName     -Output- The name of the file to be read in by      *
C      *                    the routine InDat. Input from TREGRO, or   *
C      *                    read into the model by the routine InParam.*
C      *                    Unitless.                                  *
C      *                    (Common block VModel, file VModel.f)       *
C      * InFile    -Input - The file name of the input parameter file. *
C      *                    Unitless.                                  *
C      * L         -Local - Index variable.  Unitless.                 *
C      * LfNut     -Output- A vector, of size NComp, of the amount of  *
C      *                    each nutrient in the leaves that senesced  *
C      *                    during the day.  Units are g nutrients.    *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * N         -Local - Index variable.  Unitless.                 *
C      * NLayers   -Input - The number of soil layers in the system.   *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Unitless.         *
C      *                    (Common block VPos, file VModel.f)         *
C      * NumRuns   -Output- The number of times the soil chemistry     *
C      *                    model is to be called.  Unitless.          *
C      * NuTake    -Output- A matrix of size NComp by NLayers,  of the *
C      *                    nutrients taken up by the tree in TREGRO   *
C      *                    for each layer.  The order of nutrients is *
C      *                    found by using the array SpIndex.          *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Units are mol.    *
C      *                    (Common block VModel, file VModel.f)       *
C      * Outfile   -Output- Name of output data file.  Input from      *
C      *                    TREGRO, or read into the model by the      *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VModel, file VModel.f)       *              
C      * RtNut     -Output- A matrix, NLayers by NComps, of the        *
C      *                    amount of nutrients in the roots, in each  *
C      *                    layer, that senesced during the day.  Input*
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Units are g nutr.        *
C      *                    (Common block VDecomp, file VModel.f)      *
C      * SLMoist   -Output- A vector, of size NLayers, of soil moisture*
C      *                    for each layer.  Input from TREGRO, or read*
C      *                    into the model by the routine InParam.     *
C      *                    Units are mm water.                        *
C      * SmlTos    -Local - Holds small unused strings read in from    *
C      *                    file.  Unitless.                           *
C      * SpName    -Output- A vector, of size SpNum, of names of       *
C      *                    species of interest.  Input from TREGRO, or*
C      *                    read into the model by the routine InParam.*
C      *                    Unitless.                                  *
C      *                    (Common block VIF, file VModel.f)          *
C      * SpNum     -Output- The number of species of interest.  Input  *
C      *                    from TREGRO, or read into the model by the *
C      *                    routine InParam.  Unitless.                *
C      *                    (Common block VIF, file VModel.f)          *
C      * TFlag     -Output- A flag that indicates whether the model or *
C      *                    test program will be run.  Unitless.       *
C      * Theta     -Output- A vector, of size NLayers, of volumetric   *
C      *                    soil moisture contents for each layer.     *
C      *                    Input from TREGRO, or read into the model  *
C      *                    by the routine InParam.  Units are         *
C      *                    cm**3/cm**3.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * Thickness -Output- A vector, of size NLayers, of thicknesses  *
C      *                    of each soil layer.  Input from TREGRO, or *
C      *                    read into the model by the routine InParam.*
C      *                    Units are m.                               *
C      *                    (Common block VModel, file VModel.f)       *
C      * Toss      -Local - Holds unused strings read in from input    *
C      *                    file.  Unitless.                           *
C      * WFlux     -Output- A vector, of size NLayers, of net water    *
C      *                    fluxes between layers.  Flux(0) is the net *
C      *                    flux between the atmosphere and the top    *
C      *                    layer, Flux(1) is the net flux between     *
C      *                    layers number 1 and 2, Flux(3) is the net  *
C      *                    flux between layers number 3 and 4.  If    *
C      *                    the flux is positive, the water is moving  *
C      *                    down; if the flux is negative, the water is*
C      *                    moving up.  Input from TREGRO, or read into*
C      *                    the model by the routine InParam.  Units   *
C      *                    are L/(m**2 sec).                          *                     
C      *                    (Common block VModel, file VModel.f)       *
C      *****************************************************************
	      SUBROUTINE INPARAM(INFILE, TFLAG, NUMRUNS)
							IMPLICIT NONE
							INCLUDE 'VMODEL.INC'
							CHARACTER*9 SMLTOS
							CHARACTER*80 TOSS
       CHARACTER*255 INFILE
							INTEGER L, N, NUMRUNS, TFLAG
	   
C      *----------------*
C      * Open the file. *
C      *----------------*
	      OPEN(UNIT=10, FILE=INFILE)
	   
C      *---------------------------------------*
C      * Read in the version number, not used. *
C      *---------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) TOSS
	   
C      *----------------------------------------------------------*
C      * Read in the label, then the name of the data input file, *
C      * but don't use it. The input file name is now created from*
C      * the ".Tree" name.                                        *
C      *----------------------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) FNAME
       N = INDEX(INFILE,'    ')
       FNAME = INFILE(:N-6)

C      *------------------------------------------------------------*
C      * Read in the label, then the name of the data output file,  *
C      * but don't use it. The output file name is now created from *
C      * the input data filename.                                   *
C      *------------------------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) OUTFILE
       N = INDEX(FNAME,'    ')
       OUTFILE = FNAME(:N-1) // '.Out'

C      *----------------------------------------*
C      * Read in the label then the tester flag.*
C      *----------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) TFLAG
	   
C      *--------------------------------------------*
C      * Read in the label then the first time flag.*
C      *--------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) FRSTIM
	   
C      *-------------------------------------------*
C      * Read in the label then the number of runs.*
C      *-------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) NUMRUNS
	   
C      *--------------------------------------------*
C      * Read in the label then the elapsed time.   *
C      *--------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) ELAPT
	   
C      *---------------------------------------------*
C      * Read in the label then the number of layers.*
C      *---------------------------------------------*
       READ(10,*) TOSS
	      READ(10,*) NLAYERS

C      *---------------------------*	   
C      * Read in the bulk density. *
C      *---------------------------*	   
       DO 100 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) BLKDENS(L)
  100  CONTINUE
          
C      *-------------------------*	   
C      * Read in the catch area. *
C      *-------------------------*	   
       DO 110 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) CATCHAREA(L)
  110  CONTINUE
          
C      *--------------------*	   
C      * Read in the theta. *
C      *--------------------*	   
       DO 120 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) THETA(L)
  120  CONTINUE
          
C      *------------------------*	   
C      * Read in the thickness. *
C      *------------------------*	   
       DO 130 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) THICKNESS(L)
  130  CONTINUE
          
C      *---------------------------*	   
C      * Read in the water fluxes. *
C      *---------------------------*	   
       DO 140 L = 0, 10
          READ(10,*) TOSS
          READ(10,*) WFLUX(L)
  140  CONTINUE
          
C      *-------------------------------------------------*
C      * Read in the label then the number of species of *
C      * interest.                                       *
C      *-------------------------------------------------*
       READ(10,*) TOSS
       READ(10,*) SPNUM
 
C      *----------------------------------------*	   
C      * Read in the species of interest names. *
C      *----------------------------------------*	   
       DO 145 N = 1, 6
          READ(10,*) TOSS
          READ(10,*) SPNAME(N)
  145  CONTINUE
          
C      *------------------------------*	   
C      * Read in the nutrient uptake. *
C      *------------------------------*	   
       DO 150 N = 1, 6
          DO 155 L = 1, 10
             READ(10,*) TOSS
             READ(10,*) NUTAKE(N,L)
  155     CONTINUE
  150  CONTINUE
        
C      *-----------------------------------------------------------*
C      * Read in the label then the root senescence for each layer.*
C      *-----------------------------------------------------------*
	      DO 210 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) RTSENESC(L)
  210  CONTINUE

C      *---------------------------------------------*    
C      * Read in the label then the leaf senescence. *
C      *---------------------------------------------* 
       READ(10,*) TOSS
       READ(10,*) LFSENESC
   
C      *-------------------------------------------------------------*
C      * Read in the label then the soil temperatures for each layer.*
C      *-------------------------------------------------------------*
	      DO 220 L = 1, 10
          READ(10,*) TOSS
          READ(10,*) SLTEMP(L)
  220  CONTINUE

C      *---------------------------------------------------*
C      * Read in the label then the nutrient pools in the  *
C      * leaves.                                           *
C      *---------------------------------------------------*
	      DO 230 N=1, 6
          READ(10,*) TOSS
          READ(10,*) LFNUT(N)
  230  CONTINUE
    
C      *---------------------------------------------------*
C      * Read in the label then the nutrient pools in the  * 
C      * roots for each layer.                             *
C      *---------------------------------------------------*
	      DO 240 L=1, 10
          DO 250 N = 1, 6
             READ(10,*) TOSS
             READ(10,*) RTNUT(N,L)
  250     CONTINUE
  240  CONTINUE
    
C      *----------------*
C      * Close the file *
C      *----------------*
       CLOSE(UNIT=10)

C      *----------------------------------------------------------*
C      * Calculate the soil moisture in mm H2O for use in decomp. *
C      * routines.                                                *
C      *----------------------------------------------------------*
       DO 500 L=1, NLAYERS
          SLMOIST(L) = THETA(L) * THICKNESS(L) * 1000.0
  500  CONTINUE

	      RETURN
	      END
C      *****************************************************************
C      *                    END SUBROUTINE                             *
C      *****************************************************************

